 ; Ŀ
 ;   Candy - general purpose - put a cdf/csv file into blocks.             
 ;   Copyright 1995, 1997, 2002, 2004, 2006, 2007, 2010                    
 ;   by Rocket Software Ltd.                                               
 ;   The pen is mightier than the sword, but harder to open beer with.     
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Insbloc - insert a block.                                             
 ;   Takes three arguments: Blnam, the block name.                         
 ;                          Pa, the insertion point.                       
 ;                          Llist, the attribute value list.               
 ;   Returns nothing.                                                      
 ; 
 (DEFUN INSBLOC (blnam pa llist / nexstr)
 ; Ŀ
 ;   Insert a data block, read the values from the string list Llist into  
 ;   the attributes.                                                       
 ; 
  (command ".insert" blnam pa "" "" "")
  (while (and (setq nexstr (car llist))
              (= 1 (getvar "cmdactive")))
         (setq llist (cdr llist))
         (command nexstr))
 ; Ŀ
 ;   Fill leftover attributes with empty strings.                          
 ; 
  (while (= 1 (getvar "cmdactive")) (command "")))
 ; Ŀ
 ;   Insbloc end.                                                          
 ; 

 ; Ŀ
 ;   NotMt - see if a list contains anything but empty strings.            
 ;   Arguments: Lista, a list.                                             
 ;   Calls nothing, returns T = ok, or nil = empty.                        
 ; 
 (DEFUN NOTMT (lista / sub)
  (while (and (setq sub (car lista))
              (member sub '("" "-" " " "  " "_" "." "0" "CU")))
         (setq lista (cdr lista)))
 (if lista t nil))
 ; Ŀ
 ;   NotMt end.                                                            
 ; 

 ; Ŀ
 ;   Nooke - remove commas from strings which excel has encapsulated in    
 ;   double quotes so that Splat doesn't make one string into several.     
 ;   Takes one argument, the raw data string, returns another.             
 ; 
 (DEFUN NOOKE (linn / base pos inquot)
 ; Ŀ
 ;   Fields containing 38" are exported by Excel as "38""", so call Chug   
 ;   to change "" to |+, then " to nothing, then |+ back to ".             
 ; 
  (setq linn (car (chug "\"\"" "|+" linn)))
  (setq linn (car (chug "\"" "" linn)))
  (setq linn (car (chug  "|+" "\"" linn)))
 linn)
 ; Ŀ
 ;   Nooke end.                                                            
 ; 

 ; Ŀ
 ;   Candy.                                                                
 ; 
 (DEFUN C:CANDY (/ *error* attdi attra entt blay blnam ss insp pa vdist filnam
                                                               llist fn noemo)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq attdi (getvar "attdia"))
  (setvar "attdia" 0)
  (setq attra (getvar "attreq"))
  (setvar "attreq" 1)
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (setvar "attdia" attdi)
  (setvar "attreq" attra)
  (setvar "osmode" osmo)
  (command ".undo" "end")
  (write-line shk)
 (princ))
 ; Ŀ
 ;   Get a block name by selection.                                        
 ; 
  (if (setq blnam (entsel "Select Block: "))
      (setq blnam (cdr (assoc 2 (setq entt (entget (car blnam)))))))
 ; Ŀ
 ;   Consider making its layer current.                                    
 ; 
  (setq blay (cdr (assoc 8 entt)))
  (if (not (equal blay (getvar "clayer")))
      (progn
           (initget 0 "Yes No")
           (setq insp (getkword (strcat "\nPut blocks on layer " blay
                                        "? <Y>: ")))
           (if (or (null insp) (= insp "Yes"))
               (setvar "clayer" blay))))
 ; Ŀ
 ;   Erase all insertions of that block, but ask first.                    
 ; 
  (initget 0 "Yes No")
  (Setq insp (getkword "\nErase all Insertions? <Y>: "))
  (if (or (null insp) (= insp "Yes"))
      (progn
           (if (setq ss (ssget "X" (list (cons 2 blnam))))
               (command "erase" ss ""))))
 ; Ŀ
 ;   Ask whether to ignore empty csv lines.                                
 ; 
  (initget 0 "Yes No Ignore")
  (setq insp (getkword "\nIgnore Empty Csv Lines? <Y>: "))
  (if (or (null insp) (member insp '("Yes" "Ignore")))
      (setq noemo t))
 ; Ŀ
 ;   Get a data file name.                                                 
 ; 
  (cond ((= (type filnam) 'STR)
         (setq filnam (getfiled "Data File" filnam "" 4)))
        ((zerop (getvar "dwgtitled"))
         (setq filnam (getfiled "Data File" "" "" 4)))
        (t
         (setq filnam (getfiled "Data File" (getvar "dwgprefix") "" 20))))
 ; Ŀ
 ;   Start point.                                                          
 ; 
  (setq pa (getpoint "Start Point: "))
 ; Ŀ
 ;   Vertical distance.                                                    
 ; 
  (setq vdist (getdist pa "Vertical Spacing: "))
 ; Ŀ
 ;   Insert blocks while there are lines in the file.                      
 ; 
  (if (and filnam (setq fn (open filnam "r")))
      (progn
           (setvar "osmode" 0)
           (while (setq linn (read-line fn))
                  (setq linn (nooke linn))
                  (setq llist (csplit linn))
                  (if (or (null noemo)
                          (notmt llist))
                      (progn
                           (insbloc blnam pa llist)
                           (setq pa (polar pa (* pi 1.5) vdist)))))
           (close fn)))
 ; Ŀ
 ;   Exit neatly.                                                          
 ; 
  (*error* "")
 (princ))